#ifndef _SRCSTATE_RAMPUP_REQUESTING_H_
#define _SRCSTATE_RAMPUP_REQUESTING_H_

#include "AudioStack/SMT/clSrcState.h"

/*!************************************************************************
 * FILE :         clSrcState_RampUpRequesting.h
 * SW-COMPONENT:  Audio Engine / Statemachine
 * DESCRIPTION:
 * CLASS:         RampUpRequesting
 *
 * The AudioSource can have the RampUp states:
 * - RampUp
 * - RampUpInit
 * - RampUpRequesting
 * The RampUp-State had to be devided into these sub-states due to the
 * following reasons:
 * 1) When a source is in rampUp state and an Off-request arrives,
 *    this off-request might not be confirmed by FC-Audio depending on
 *    if prev. play-request have already been confirmed.
 *    So it has to be differentiated, if FC-Audio already confirmed
 *    the prev. request or not.
 *    If not, we might not send an off again. Instead we have to
 *    create a manual confirmation on our own.
 * 2) The init-substate was introduced to facilitate the init-phase
 *    in audiosource, which have to prepare the players before requesting
 *    a play on FC-Audio.
 *    During this init-phase, an off-request also has to be confirmed manually
 *
 * AUTHOR:        CM-DI/PJ-VW34 Steinle
 * COPYRIGHT:     (c) 2006 Blaupunkt Werke
 * MODIFIED:      14.03.2013, R. Volkmer
 *************************************************************************/


namespace AudioStack {  namespace SourceStateMachine
{


class clSrcState_RampUpRequesting : public clSrcState
{
public:
    clSrcState_RampUpRequesting() : clSrcState("rampupRequesting", AudioSource::AudioStates::RAMPUPREQUEST){};
   virtual tVoid vEnter(AudioSource::clAudioSource* pclAudioSource, tU32 u32UserData, tU8 enEntryCondition);
   virtual tVoid vMsg_Off(AudioSource::clAudioSource* pclAudioSource, tU32 u32UserData);
   virtual tVoid vMsg_Pause(AudioSource::clAudioSource* pclAudioSource, tU32 u32UserData);
   virtual tVoid vMsg_On(AudioSource::clAudioSource* pclAudioSource, tU32 u32UserData);
   virtual tVoid vMsg_OnDone(AudioSource::clAudioSource* pclAudioSource, tU32 u32UserData);
   virtual tVoid vMsg_RequestConfirmed(AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_ServiceAvailable(AudioSource::clAudioSource* src, tU32 u32UserData);
};

}}

#endif  //_SRCSTATE_RAMPUP_H_
